/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Adc.c
  \brief    	
  \author   	Freescale Semiconductor
  \author     r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date     	6/27/2008 9:51:50 AM
  
  * History:
  
*/
/****************************************************************************************/
#include "Adc.h"

/** Holds the ADC result from any of the RFIFO buffers */
static uint16_t u16AdcConvResult = 0;
static uint32_t u32RawAdc75Ref = 0;
static uint32_t u32RawAdc25Ref = 0;
static uint32_t Result = 0;         /* ADC conversion result  */
/****************************************************************************************/
/**
 * \brief     Initialize Adc0 module with Predefined parameters established at \n
              Adc_Cfg.h file.
 * \author    R01160
 * \param     none
 * \return    none
 * \warning   This function shall be invoked once at initialization.
 */  
void vfnAdc_Init(void)
{
     
  /* Writes a Configuration Command */
  ADC_WRITE_CONFIG_CMD(au32Adc_Config_Params[ADC_ASSIGNED_CONFIG_PARAMS],ADC_FIFO_BUFFER);
  /* Triggers ADC channel 0 using CFIFO 1        */
  ADC_WRITE_CONTROL_CMD(ADC_CTRL_CMD_1,ADC_FIFO_BUFFER);
  /* Interrupt and DMA Control Registers (EQADC_IDCR) IDCR0*/
  ADC_DMA_CR(ADC_FIFO_BUFFER,0x0303);  
         /*	NonCoherency Interrupt is : Disabled        */
         /*	Trigger Overrun Interrupt is : Disabled     */
         /*	Pause Interrupt is : Disabled               */
         /*	End Of Queue Interrupt is : Enabled         */
         /*	CFIFO Underflow Interrupt is : Enabled      */
         /*	CFIFO Fill Enable is : Enabled              */
         /*	CFIFO Fill Select : DMA                     */
         /*	RFIFO Overflow Interrupt is : Enabled       */
         /*	RFIFO Drain is : Enabled                    */
         /*	RFIFO Drain Select is : DMA                 */

  /* Wait for End Of Queue flag    */
  while (ADC_END_OF_QUEUE_FLAG(ADC_FIFO_BUFFER) != 1) {} 
  /* Clear End Of Queue flag       */
  ADC_END_OF_QUEUE_FLAG(ADC_FIFO_BUFFER) = 1;     
}


/****************************************************************************************/
/**
 * \brief     Initialize Adc Command queues and enables eDMA functionality.
 * \author    R01160
 * \param     none
 * \return    none
 * \warning   This function shall be invoked once at initialization.
 */  
void eqadc_init_fnc (void)
{
    
    cQUEUE[0] = 0;  /* Queue 0 Initialization */
    cQUEUE[1] = 0;  /* Queue 1 Initialization */
    cQUEUE[2] = 0;  /* Queue 2 Initialization */
    cQUEUE[3] = 0;  /* Queue 3 Initialization */
   
/* ----------------------------------------------------------- */
/*	EQADC Module Configuration Register (EQADC_MCR)        */
/* ----------------------------------------------------------- */
    EQADC.MCR.R = 0x00000000;
            /*	EQADC SSI is Disabled             */
            /*	Debug Mode Disabled              */

/* ----------------------------------------------------------- */
/*	NULL Message Send Format Register (EQADC_NMSFR)        */
/* ----------------------------------------------------------- */
    EQADC.NMSFR.R = 0x00000000;
            /*	Null Message Format value : 0   */

/* ----------------------------------------------------------- */
/*	EQADC External Trigger Digital Filter Register (EQADC_ETDFR)        */
/* ----------------------------------------------------------- */
   EQADC.ETDFR.R  = 0x00000000;
         /*	Digital Filter Length 2  */


/* ----------------------------------------------------------- */
/*	EQADC CFIFO Control Register  (EQADC_CFCR) CFCR0       */
/* ----------------------------------------------------------- */
   EQADC.CFCR[0].R = 0x0010;
         /* Single Scan Enable Bit  : Disabled            */
         /* CFIFO Invalidate Bit : Disabled               */
         /* CFIFO Operation Mode :   Single                 */
         /* Trigger  : Software trigger                           */

/* ----------------------------------------------------------- */
/*	Interrupt and DMA Control Registers (EQADC_IDCR) IDCR0*/
/* ----------------------------------------------------------- */
   EQADC.IDCR[0].R = 0x0000;
         /*	NonCoherency Interrupt is : Disabled        */
         /*	Trigger Overrun Interrupt is : Disabled     */
         /*	Pause Interrupt is : Disabled               */
         /*	End Of Queue Interrupt is : Disabled        */
         /*	CFIFO Underflow Interrupt is : Disabled     */
         /*	CFIFO Fill Enable is : Disabled             */
         /*	CFIFO Fill Select : IRQ                */
         /*	RFIFO Overflow Interrupt is : Disabled      */
         /*	RFIFO Drain is : Disabled                   */
         /*	RFIFO Drain Select is : IRQ            */

/* ----------------------------------------------------------- */
/*	ADC Time Stamp Control Register (ADC_TSCR)     */
/* ----------------------------------------------------------- */
   EQADC.CFPR[0].B.CFPUSH  = 0x00000002;
         /* Initialize the Time Stamp Control Register */
         /*  ADC.TSCR = 0x0000;                            */
         /*  Bits 12-15 Time Base Counter prescalar :0     */
/* ----------------------------------------------------------- */
/*	EQADC ADC Time Base Counter Register (ADC_TBCR)    */    
/* ----------------------------------------------------------- */
/*    ADC_TBCR  = 0x0000;*/
            /* Time base counter value  */
    EQADC.CFPR[0].B.CFPUSH = 0x00000003;
            /* Initialize the Time Base Counter Register      */

/* ----------------------------------------------------------- */
/*	EQADC ADC Control Register (ADC_CR0)   */
/* ----------------------------------------------------------- */
         /*  ADC_CR = 0x800F;                             */
         /*	Bits 11-15 Clock Prescalar  32              */
         /*	Bit 4 External Mux Enable : Disabled        */
         /*	Bit 0 Enable ADC0 Ready to Start :Enabled  */
   EQADC.CFPR[0].B.CFPUSH  = 0x00800F01;
         /* Initialize the ADC Control Register     */

/* ----------------------------------------------------------- */
/*	EQADC ADC Control Register (ADC_CR1)   */
/* ----------------------------------------------------------- */
         /*  ADC_CR = 0x800F;                             */
         /*	Bits 11-15 Clock Prescalar  32              */
         /*	Bit 4 External Mux Enable : Disabled        */
         /*	Bit 0 Enable ADC1 Ready to Start :Enabled  */
   EQADC.CFPR[0].B.CFPUSH  = 0x82800F01;
         /* Initialize the ADC Control Register     */

    EQADC.CFCR[0].B.SSE  = 0x01;
        /*	Trigger the CFIFO  0to configure ADC0*/
    while(EQADC.CFSR.B.CFS0 == 0x3){};
        /* Wait for Triggered State to end so we know queue is done */
    EQADC.FISR[0].B.EOQF = 0x01;
        /* Clear the end of queue flag for the configuration command sets.  */
    EQADC.CFCR[0].R = 0x0000;
        /* Disable the queue in preparation for queue mode change.  */
    while(EQADC.CFSR.B.CFS0 != 0x0){};
        /* Wait for queue to go to IDLE before setting mode to user setting. */

/* ----------------------------------------------------------- */
/*	Interrupt and DMA Control Registers (EQADC_IDCR) IDCR0*/
/* ----------------------------------------------------------- */
   EQADC.IDCR[0].R = 0x0303;
         /*	NonCoherency Interrupt is : Disabled        */
         /*	Trigger Overrun Interrupt is : Disabled     */
         /*	Pause Interrupt is : Disabled               */
         /*	End Of Queue Interrupt is : Disabled        */
         /*	CFIFO Underflow Interrupt is : Disabled     */
         /*	CFIFO Fill Enable is : Enabled             */
         /*	CFIFO Fill Select : DMA                */
         /*	RFIFO Overflow Interrupt is : Disabled      */
         /*	RFIFO Drain is : Enabled                   */
         /*	RFIFO Drain Select is : DMA            */

/* ----------------------------------------------------------- */
/*	Interrupt and DMA Control Registers (EQADC_IDCR) IDCR1*/
/* ----------------------------------------------------------- */
   EQADC.IDCR[1].R = 0x0000;
         /*	NonCoherency Interrupt is : Disabled        */
         /*	Trigger Overrun Interrupt is : Disabled     */
         /*	Pause Interrupt is : Disabled               */
         /*	End Of Queue Interrupt is : Disabled        */
         /*	CFIFO Underflow Interrupt is : Disabled     */
         /*	CFIFO Fill Enable is : Disabled             */
         /*	CFIFO Fill Select : IRQ                */
         /*	RFIFO Overflow Interrupt is : Disabled      */
         /*	RFIFO Drain is : Disabled                   */
         /*	RFIFO Drain Select is : IRQ            */

/* ----------------------------------------------------------- */
/*	Interrupt and DMA Control Registers (EQADC_IDCR) IDCR2*/
/* ----------------------------------------------------------- */
   EQADC.IDCR[2].R = 0x0000;
         /*	NonCoherency Interrupt is : Disabled        */
         /*	Trigger Overrun Interrupt is : Disabled     */
         /*	Pause Interrupt is : Disabled               */
         /*	End Of Queue Interrupt is : Disabled        */
         /*	CFIFO Underflow Interrupt is : Disabled     */
         /*	CFIFO Fill Enable is : Disabled             */
         /*	CFIFO Fill Select : IRQ                */
         /*	RFIFO Overflow Interrupt is : Disabled      */
         /*	RFIFO Drain is : Disabled                   */
         /*	RFIFO Drain Select is : IRQ            */

/* ----------------------------------------------------------- */
/*	Interrupt and DMA Control Registers (EQADC_IDCR) IDCR3*/
/* ----------------------------------------------------------- */
   EQADC.IDCR[3].R = 0x0000;
         /*	NonCoherency Interrupt is : Disabled        */
         /*	Trigger Overrun Interrupt is : Disabled     */
         /*	Pause Interrupt is : Disabled               */
         /*	End Of Queue Interrupt is : Disabled        */
         /*	CFIFO Underflow Interrupt is : Disabled     */
         /*	CFIFO Fill Enable is : Disabled             */
         /*	CFIFO Fill Select : IRQ                */
         /*	RFIFO Overflow Interrupt is : Disabled      */
         /*	RFIFO Drain is : Disabled                   */
         /*	RFIFO Drain Select is : IRQ            */

/* ----------------------------------------------------------- */
/*	Interrupt and DMA Control Registers (EQADC_IDCR) IDCR4*/
/* ----------------------------------------------------------- */
   EQADC.IDCR[4].R = 0x0000;
         /*	NonCoherency Interrupt is : Disabled        */
         /*	Trigger Overrun Interrupt is : Disabled     */
         /*	Pause Interrupt is : Disabled               */
         /*	End Of Queue Interrupt is : Disabled        */
         /*	CFIFO Underflow Interrupt is : Disabled     */
         /*	CFIFO Fill Enable is : Disabled             */
         /*	CFIFO Fill Select : IRQ                */
         /*	RFIFO Overflow Interrupt is : Disabled      */
         /*	RFIFO Drain is : Disabled                   */
         /*	RFIFO Drain Select is : IRQ            */

/* ----------------------------------------------------------- */
/*	Interrupt and DMA Control Registers (EQADC_IDCR) IDCR5*/
/* ----------------------------------------------------------- */
   EQADC.IDCR[5].R = 0x0000;
         /*	NonCoherency Interrupt is : Disabled        */
         /*	Trigger Overrun Interrupt is : Disabled     */
         /*	Pause Interrupt is : Disabled               */
         /*	End Of Queue Interrupt is : Disabled        */
         /*	CFIFO Underflow Interrupt is : Disabled     */
         /*	CFIFO Fill Enable is : Disabled             */
         /*	CFIFO Fill Select : IRQ                */
         /*	RFIFO Overflow Interrupt is : Disabled      */
         /*	RFIFO Drain is : Disabled                   */
         /*	RFIFO Drain Select is : IRQ            */


/* ----------------------------------------------------------- */
/*	EQADC CFIFO Control Register  (EQADC_CFCR) CFCR0       */
/* ----------------------------------------------------------- */
   EQADC.CFCR[0].R = 0x0010;
         /* Single Scan Enable Bit  : Disabled            */
         /* CFIFO Invalidate Bit : Disabled               */
         /* CFIFO Operation Mode :   Single                 */
         /* Trigger  : Software trigger                           */


/* ----------------------------------------------------------- */
/*	EQADC CFIFO Control Register  (EQADC_CFCR) CFCR1       */
/* ----------------------------------------------------------- */
   EQADC.CFCR[1].R = 0x0000;
         /* Single Scan Enable Bit  : Disabled            */
         /* CFIFO Invalidate Bit : Disabled               */
         /* CFIFO Operation Mode : Disabled                */
         /* Trigger  : Disabled                           */


/* ----------------------------------------------------------- */
/*	EQADC CFIFO Control Register  (EQADC_CFCR) CFCR2       */
/* ----------------------------------------------------------- */
   EQADC.CFCR[2].R = 0x0000;
         /* Single Scan Enable Bit  : Disabled            */
         /* CFIFO Invalidate Bit : Disabled               */
         /* CFIFO Operation Mode : Disabled                */
         /* Trigger  : Disabled                           */


/* ----------------------------------------------------------- */
/*	EQADC CFIFO Control Register  (EQADC_CFCR) CFCR3       */
/* ----------------------------------------------------------- */
   EQADC.CFCR[3].R = 0x0000;
         /* Single Scan Enable Bit  : Disabled            */
         /* CFIFO Invalidate Bit : Disabled               */
         /* CFIFO Operation Mode : Disabled                */
         /* Trigger  : Disabled                           */


/* ----------------------------------------------------------- */
/*	EQADC CFIFO Control Register  (EQADC_CFCR) CFCR4       */
/* ----------------------------------------------------------- */
   EQADC.CFCR[4].R = 0x0000;
         /* Single Scan Enable Bit  : Disabled            */
         /* CFIFO Invalidate Bit : Disabled               */
         /* CFIFO Operation Mode : Disabled                */
         /* Trigger  : Disabled                           */


/* ----------------------------------------------------------- */
/*	EQADC CFIFO Control Register  (EQADC_CFCR) CFCR5       */
/* ----------------------------------------------------------- */
   EQADC.CFCR[5].R = 0x0000;
         /* Single Scan Enable Bit  : Disabled            */
         /* CFIFO Invalidate Bit : Disabled               */
         /* CFIFO Operation Mode : Disabled                */
         /* Trigger  : Disabled                           */


}


/****************************************************************************************/
/**
 * \brief     Start ADC conversions by triggering the eDMA module. 
 * \author    R01160
 * \param     none
 * \return    none
 */  
void eqadc_cfifo0_sw_trigger_fnc (void)
{
    
	ADC_SET_SSE_BIT(ADC_FIFO_BUFFER);   /* Set SSE bit on CFCRx register          */
									    /* Single Scan Enable Bit: 1              */
                                        /* Trigger -  :Software trigger           */
                                        /* CFIFO Operation Mode :  Single         */
            
}


/****************************************************************************************/
/**
 * \brief     Read an ADC result from a desired ADC channel. 
 * \author    R01160
 * \param     none
 * \return    ADC result returned in 16-bit
 */  
uint16_t u16Read_Adc_Result(uint8_t u8AdcFifoBuffer)
{
  while(EDMA.TCD[1].DONE != 1)
  {
  	;;
  }
 

  ADC_RFIFO_FLAG(u8AdcFifoBuffer) = 1;                   /* Clear RFIFOx Drain Flag                */
  ADC_END_OF_QUEUE_FLAG(u8AdcFifoBuffer) = 1;            /* Clear CFIFOx End of Queue flag         */
  
  return((uint16_t)rQUEUE0);	

}

/****************************************************************************************/
/**
 * \brief     Wait until an ADC channel has a valid result. This functions polls the \n
 *            eDMA x Channel to validate a ADC result.
 * \author    R01160
 * \param     none
 * \return    none
 */  
void vfnWait_Till_Valid_Adc_Result(uint8_t u8AdcFifoBuffer)
{
	  uint16_t u16Adc_Results[12];
	  uint16_t u16NonBlockCntr = 0;  /* Serves to break the while condition in case eDMA flag never changes */
	  
	  /* Does eDMA finishes to convert all ADC Channels or the counter expires yet? */
	  while((EDMA.TCD[1].DONE != 1) && (u16NonBlockCntr <= 0xFFFF))
	  {
	    u16NonBlockCntr++;	
	  }
	 
      u16Adc_Results[0] = (uint16_t)((uint16_t)rQUEUE0[0] >> (uint16_t)2);
      u16Adc_Results[1] = (uint16_t)((uint16_t)rQUEUE0[1] >> (uint16_t)2);
      u16Adc_Results[2] = (uint16_t)((uint16_t)rQUEUE0[2] >> (uint16_t)2);
      u16Adc_Results[3] = (uint16_t)((uint16_t)rQUEUE0[3] >> (uint16_t)2);
     
	  ADC_RFIFO_FLAG(u8AdcFifoBuffer) = 1;                   /* Clear RFIFOx Drain Flag                */
	  ADC_END_OF_QUEUE_FLAG(u8AdcFifoBuffer) = 1;            /* Clear CFIFOx End of Queue flag         */
	  
}

/****************************************************************************************/
/**
 * \brief     calculates ADC calibration values and write those values into \n
              GCC & OCC registers
 * \author    R01160
 * \param     Buffer number (FIFO)
 * \return    none
 * \warning   This function shall be invoked once at initialization.
 */  
void vfnInitAdc_Calibration(uint32_t u32dac)
{
  uint32_t i;
  /* These variables holds internal ADC reference voltages */
  uint32_t u32vr25, u32vr75;
  /* Arm configuration commands                            */
  uint32_t u32ArmCmd = 0;
  /* Holds gcc and occ final values to be written into GCC & OCC registers */
  uint32_t u32gcc, u32occ;

  
  ADC_WRITE_CONFIG_CMD((0x002c2b00 + (u32dac<<25)), ADC_FIFO_BUFFER_0); /* channel == 43 (0x2b) 3/4VRH  */                  
  ADC_WRITE_CONFIG_CMD((0x803c2c00 + (u32dac<<25)), ADC_FIFO_BUFFER_0); /* channel == 44 (0x2c) 1/4VRH  */                 
  ADC_SET_SSE_BIT(ADC_FIFO_BUFFER);                                  /* software trigger             */

  for (i=0;i<20000;i++){ ;; }    	                                 /* make sure all conversions are finished */

/* get results */
  u32vr75 = ADC_READ_RESULT(ADC_FIFO_BUFFER_0);	 /* 75%*VRH */
  u32vr25 = ADC_READ_RESULT(ADC_FIFO_BUFFER_1);	 /* 25%*VRH  */

/* Calculate calibration gain and offset */
  u32gcc = (uint32_t)((uint32_t)(ADC_75_REF_CHANNEL - ADC_25_REF_CHANNEL)<< (uint32_t)14);
  u32gcc = u32gcc / (u32vr75 - u32vr25);
  u32occ = u32gcc * u32vr75;
  u32occ = u32occ>>14;
  u32occ = ADC_75_REF_CHANNEL - u32occ -2;

  u32gcc = u32gcc << 8;
  u32occ = u32occ << 8;
  u32gcc = (uint32_t)((uint32_t)0x00ffff00 & (uint32_t)u32gcc);
  u32occ = (uint32_t)((uint32_t)0x00ffff00 & (uint32_t)u32occ);

  /* Assembling command to write into gcc register   */
  u32ArmCmd = (uint32_t)((uint32_t)0x00000004 | (uint32_t)u32gcc | (uint32_t)(u32dac<<25));
  /* write gcc register                              */                    
  ADC_WRITE_CONFIG_CMD(u32ArmCmd,ADC_FIFO_BUFFER_0);                
  /* Assembling command to write into OCC register   */
  u32ArmCmd = (uint32_t)((uint32_t)0x80000005 | (uint32_t)u32occ | (uint32_t)(u32dac<<25));
  /* Write occ                                       */
  ADC_WRITE_CONFIG_CMD(u32ArmCmd,ADC_FIFO_BUFFER_0); 
   /* Software trigger                               */
  ADC_SET_SSE_BIT(ADC_FIFO_BUFFER);                  

  
} /* end of Calibrate */

